<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<!--
/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2003
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="wcl" uri="WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>

<%@page contentType="text/html;charset=UTF-8" 
		language="java"
		import="com.ibm.psw.reuse.gen.*,
                com.ibm.hwmca.ui.bonsai.*,
                com.ibm.hwmca.ui.bonsai.earth.*,
                com.ibm.hwmca.ui.bonsai.servlet.*,
                com.ibm.hwmca.ui.bonsai.servlet.util.*,
                com.ibm.hwmca.ui.bonsai.util.*,
                com.ibm.hwmca.fw.managed.*,
                com.ibm.hwmca.fw.servlet.util.*,
                java.util.*,
                com.ibm.psw.wcl.components.table.*" %>

<META HTTP-EQUIV="Content-Type" CONTENT="text/html;CHARSET=UTF-8">
<HTML>
<HEAD>
<%  
	    ServletContext sc = session.getServletContext();		

        String id = (String)session.getAttribute(BaseServlet.CURRENT_SELECTION);
        if (id != null)
        {
            HMCSession hmcSession = HMCSession.getHMCSession(session);
            if (hmcSession == null)
               throw new IllegalStateException("No HMC session!");
            Set userRoles = User.getUser(hmcSession.getUserContext().getUserName()).getUserRoles();
            WTable table_ = new WTable(BonsaiTreeManager.getBonsaiTreeManager().getTableModel(id, userRoles),
                                       null,
                                       WTable.ALLFEATURES);
            table_.setSelectionMode(WTable.SINGLE_SELECT);

            session.setAttribute("contentarea_table", table_);
        }
  %>

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.
  ========================================================================== -->
<wcl:ControllerFoundation
	objectScope="session"
    wclFacadeScope="session"
    wclFacadeScopeId="caFacade"
    pageName="tablepage">

  <!-- =====================================================================
    Setup the NLS Resource Bundle to use in this JSP page
    ==================================================================== -->
  <wcl:ResourceBundle objectScopeId="JspResourceBundle"
                          className="com.ibm.hwmca.ui.bonsai.util.BonsaiResources"
  />

<!-- ===========================================================================
  Set the title of the browser from the Resource Bundle
  ========================================================================== -->
  <TITLE>
  <wcl:BundledResource objectScopeId="<%=BonsaiResources.JSP_HMC_TABLE_NAME%>"
               resourceBundleScopeId="JspResourceBundle"
                        defaultValue="ContentArea Table"
                            isInline="true"
  />
  </TITLE>
</HEAD>
<BODY>

  <!-- =====================================================================
    Set up the translatable resources for use in this jsp
    ==================================================================== -->        

    <!-- Sample Heading -->
    <wcl:BundledResource objectScopeId="<%=BonsaiResources.JSP_HMC_TABLE_NAME%>"
               resourceBundleScopeId="JspResourceBundle"
                        defaultValue="WSelectionBox Samples"
                            isInline="false" 
    />
  
  <!-- =========================================================================
    Let's place a WTable into a WTitledLayout to display 
    ======================================================================== -->    
  <wcl:WTitledLayout
        objectScopeId="tableLayoutScope"
                   id="mainlayout"
                title="<%=(String) pageContext.getAttribute( BonsaiResources.JSP_HMC_TABLE_NAME )%>"
          description="<%=(String) pageContext.getAttribute( BonsaiResources.JSP_HMC_TABLE_DESCRIPTION )%>"
   >

   <!-- =========================================================================
    Add the table
    ======================================================================== -->    
    <% if (session.getAttribute("contentarea_table") != null) { %>
      <wcl:WTable 
           objectScopeId="contentarea_table"
           id="wtable" 
      >
      </wcl:WTable>
      <% } else { %>no table<% } %>

      <BR>

    <BR>

    &nbsp;&nbsp;
 
    <BR>
  </wcl:WTitledLayout>
 </BODY>
</wcl:ControllerFoundation>
</HTML>

